package jp.mosp.common.part;

import java.text.NumberFormat;

import jp.mosp.common.CommonConst;

/**
 * ԁAɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class TimePart {

	/**
	 * int̎ԂStringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public static String convIntegerTimeToStringHour(int time) {
		return String.valueOf(time / 60);
	}

	/**
	 * int̕Stringɕϊ
	 * @param time
	 * @return	string	ԁij
	 */
	public static String convIntegerTimeToStringMinutes(int time) {
		return String.valueOf(time % 60);
	}

	/**
	 * String̎ԂStringɕϊ
	 * @param time HH:MM
	 * @return HH
	 */
	public static String convStringTimeToStringHour(String time) {
		if (time.equals("")) {
			return "0";
		} else {
			return convIntegerTimeToStringHour(convStringTimeToIntegerTime(time));
		}
	}

	/**
	 * String̕Stringɕϊ
	 * @param time HH:MM
	 * @return MM
	 */
	public static String convStringTimeToStringMinutes(String time) {
		if (time.equals("")) {
			return "0";
		} else {
			return convIntegerTimeToStringMinutes(convStringTimeToIntegerTime(time));
		}
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HH:MM
	 */
	public static String convIntegerTimeToStringTime(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringPart.addZero(convIntegerTimeToStringHour(time)));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(StringPart.addZero(convIntegerTimeToStringMinutes(time)));
		return sb.toString();
	}

	/**
	 * ϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public static String convIntegerTimeToJPTime(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringPart.addZero(convIntegerTimeToStringHour(time)));
		sb.append(CommonConst.NAM_HOUR);
		sb.append(StringPart.addZero(convIntegerTimeToStringMinutes(time)));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}

	/**
	 * ϊiStringintj
	 * @param time iHH:MMj
	 * @return int	i0̌oߕj
	 */
	public static int convStringTimeToIntegerTime(String time) {
		if (time.length() == 0) {
			time = "0:0";
		}
		String[] ar = time.split(CommonConst.STR_TIME_SEPARATOR);
		return convStringTimeToIntegerTime(ar[0], ar[1]);
	}

	/**
	 * ϊiStringintj
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public static int convStringTimeToIntegerTime(String hour, String min) {
		return (NumberPart.getIntParam(hour) * 60) + NumberPart.getIntParam(min);
	}

	/**
	 * ϊiStringStringj
	 * @param hour 
	 * @param min 
	 * @return	HH:mm
	 */
	public static String convStringTimeFormatted(String hour, String min) {
		StringBuffer sb = new StringBuffer();
		sb.append(StringPart.addZero(hour));
		sb.append(CommonConst.STR_TIME_SEPARATOR);
		sb.append(StringPart.addZero(min));
		return sb.toString();
	}

	/**
	 * ԕϊiintdoublej
	 * @param time int
	 * @return hh.mm <br>͂̂܂
	 * 				[] 651.05
	 */
	public static double convIntegerTimeToDoubleTime(int time) {
		double dblhour = Math.floor((double)time / 60);
		double dblmin =(double)time % 60 / 100;
		double dtime = dblhour + dblmin;
		return dtime;
	}

	/**
	 * ԕϊiintStringj
	 * <p>[] 901.5</p>
	 * <p>15Pʂ̏ꍇ̂ݗpĂB</p>
	 * @param time int
	 * @return hh.mm 
	 */
	public static String convIntegerMinToStringHour(int time) {
		double dblhour = Math.floor((double)time / 60);
		double dblmin = (double)time % 60 / 60;
		double dtime = dblhour + dblmin;
		return String.valueOf(dtime);
	}

	/**
	 * ԕϊiintStringj
	 * @param time int
	 * @return HHMM
	 */
	public static String convIntegerTimeToJPHours(int time) {
		StringBuffer sb = new StringBuffer();
		sb.append(convIntegerTimeToStringHour(time));
		sb.append(CommonConst.NAM_COMMON_TIME);
		if (convIntegerTimeToStringMinutes(time).length() < 2) {
			sb.append("0");			
		}
		sb.append(convIntegerTimeToStringMinutes(time));
		sb.append(CommonConst.NAM_MINUTES);
		return sb.toString();
	}

	/**
	 * ԃtH[}bg
	 * @param hour 
	 * @return ()
	 */
	public static String getHourString(double hour) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(2);
		nf.setMinimumFractionDigits(2);
		return nf.format(hour);
	}

	/**
	 * ϊiintintj
	 * @since	0.0.2
	 * @param hour 
	 * @param min 
	 * @return int	i0̌oߕj
	 */
	public static int convIntegerTimeToIntegerTime(int hour, int min) {
		int times = (hour * 60) + min;
		return times;
	}

}
